<?php

$xml = "<Pet>" .
		"	<Name id='4323412'>Avi</Name>" .
		"	<Species>Papuga Afrykańska</Species>" .
		"	<Gender>F</Gender>" .
		"</Pet>";
		
$pp = new PetParser($xml);
echo $pp->petName;
echo $pp->petId;

class PetParser {
	
	private $parser;
	public $tagName = "";
	public $petName;
	public $petId;

	function startElement($parser, $name, $attributes) {
		if ($name == "Name") {
			$this->tagName = $name;	
			$this->petId = $attributes['id'];
		}
	}

	function endElement($parser, $name) {
		$this->tagName = "";
	}

	function characterData($parser, $data) {
		if ($this->tagName == "Name") {
			$this->petName = $data;	
		}
	}
	
	public function __construct($xml) {
		$parser = xml_parser_create();
		xml_set_object($parser, $this);
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		xml_set_element_handler($parser, "startElement", "endElement");
		xml_set_character_data_handler($parser, "characterData");
		xml_parse($parser, $xml);	
	}
} 
?>